--------------------------------------------------------------
-- added this to allow below to compile
--------------------------------------------------------------
package test1 is
  TYPE fourval IS (X, L, H, Z);
  TYPE fourvalue IS ('X', '0', '1', 'Z');
  FUNCTION convert4val(S : fourval) RETURN fourvalue ;
end test1;
package body test1 is
--------------------------------------------------------------
FUNCTION convert4val(S : fourval) RETURN fourvalue IS
BEGIN
  CASE S IS
    WHEN X =>
      RETURN 'X';
    WHEN L =>
      RETURN '0';
    WHEN H =>
      RETURN '1';
    WHEN Z =>
      RETURN 'Z';
  END CASE;
END convert4val;
--------------------------------------------------------------
end test1;
--------------------------------------------------------------


PACKAGE my_std IS
  TYPE fourval IS (X, L, H, Z);
  TYPE fourvalue IS ('X', '0', '1', 'Z');

  TYPE fvector4 IS ARRAY(0 TO 3) OF fourval;
END my_std;

USE WORK.my_std.ALL;
ENTITY reg IS
  PORT(a : IN fvector4;
       clr : IN fourval;
       clk : IN fourval;
       q : OUT fvector4);

  FUNCTION convert4val(S : fourval)
     RETURN fourvalue IS
  BEGIN
    CASE S IS
      WHEN X =>
        RETURN 'X';
      WHEN L =>
        RETURN '0';
      WHEN H =>
        RETURN '1';
      WHEN Z =>
        RETURN 'Z';
    END CASE;
  END convert4val;

  FUNCTION convert4value(S : fourvalue)
      RETURN fourval IS
  BEGIN
    CASE S IS
      WHEN 'X' =>
        RETURN X;
      WHEN '0' =>
        RETURN L;
      WHEN '1' =>
        RETURN H;
      WHEN 'Z' =>
        RETURN Z;
    END CASE;
  END convert4value;
END reg;

ARCHITECTURE structure OF reg IS
  COMPONENT dff
    PORT(d, clk, clr : IN fourvalue;
         q : OUT fourvalue);
  END COMPONENT;
BEGIN
  U1 : dff PORT MAP(convert4val(a(0)),
           convert4val(clk),
           convert4val(clr),
           convert4value(q) => q(0));

  U2 : dff PORT MAP(convert4val(a(1)),
           convert4val(clk),
           convert4val(clr),
           convert4value(q) => q(1));

  U3 : dff PORT MAP(convert4val(a(2)),
           convert4val(clk),
           convert4val(clr),
           convert4value(q) => q(2));

  U4 : dff PORT MAP(convert4val(a(3)),
           convert4val(clk),
           convert4val(clr),
           convert4value(q) => q(3));

END structure;

